
"use strict";
var map,
    locations = {
        type: "FeatureCollection",
        features: [
            {
                type: "Feature",
                properties: {
                    name: "Forest",
                    logo: "assets/img/icons/logos/knife.svg",
                    distance: 0.3,
                    openingCount: "6pm",
                    phone: "+1 555 456-5659",
                    website: "https://ecojustice.thegreengrowth.com",
                    description: "Short Description of 10 Words about the Crime/Violation",
                },
                geometry: { type: "Point", coordinates: [-77.038659, 38.931567] },
            },
            {
                type: "Feature",
                properties: {
                    name: "Natural disaster",
                    logo: "assets/img/icons/logos/Natural_disaster.svg",
                    distance: 0.8,
                    openingCount: "5pm",
                    phone: "+1 555 154-4568",
                    website: "https://ecojustice.thegreengrowth.com",
                    description: "Short Description of 10 Words about the Crime/Violation",
                },
                geometry: { type: "Point", coordinates: [-77.003168, 38.894651] },
            },
            {
                type: "Feature",
                properties: {
                    name: "Fire",
                    logo: "assets/img/icons/logos/fire.svg",
                    distance: 1.2,
                    openingCount: "8pm",
                    phone: "+1 555 456-7897",
                    website: "https://ecojustice.thegreengrowth.com",
                    description: "Short Description of 10 Words about the Crime/Violation",
                },
                geometry: { type: "Point", coordinates: [-77.090372, 38.881189] },
            },
            {
                type: "Feature",
                properties: {
                    name: "Wildlife",
                    logo: "assets/img/icons/logos/wildlife.svg",
                    distance: 0.5,
                    openingCount: "11pm",
                    phone: "+1 555 456-5659",
                    website: "https://ecojustice.thegreengrowth.com",
                    description: "Short Description of 10 Words about the Crime/Violation",
                },
                geometry: { type: "Point", coordinates: [-77.111561, 38.882342] },
            },
            {
                type: "Feature",
                properties: {
                    name: "Pollution",
                    logo: "assets/img/icons/logos/Pollution.svg",
                    distance: 0.2,
                    openingCount: "4:30pm",
                    phone: "+1 555 456-7568",
                    website: "https://ecojustice.thegreengrowth.com",
                    description: "Short Description of 10 Words about the Crime/Violation",
                },
                geometry: { type: "Point", coordinates: [-77.052477, 38.943951] },
            },
            {
                type: "Feature",
                properties: {
                    name: "Forest",
                    logo: "assets/img/icons/logos/knife.svg",
                    distance: 0.3,
                    openingCount: "6pm",
                    phone: "+1 555 456-5659",
                    website: "https://ecojustice.thegreengrowth.com",
                    description: "Short Description of 10 Words about the Crime/Violation",
                },
                geometry: { type: "Point", coordinates: [-77.038659, 38.931567] },
            },
            {
                type: "Feature",
                properties: {
                    name: "Natural disaster",
                    logo: "assets/img/icons/logos/Natural_disaster.svg",
                    distance: 0.8,
                    openingCount: "5pm",
                    phone: "+1 555 154-4568",
                    website: "https://ecojustice.thegreengrowth.com",
                    description: "Short Description of 10 Words about the Crime/Violation",
                },
                geometry: { type: "Point", coordinates: [-77.003168, 38.894651] },
            },
            {
                type: "Feature",
                properties: {
                    name: "Fire",
                    logo: "assets/img/icons/logos/fire.svg",
                    distance: 1.2,
                    openingCount: "8pm",
                    phone: "+1 555 456-7897",
                    website: "https://ecojustice.thegreengrowth.com",
                    description: "Short Description of 10 Words about the Crime/Violation",
                },
                geometry: { type: "Point", coordinates: [-77.090372, 38.881189] },
            },
            {
                type: "Feature",
                properties: {
                    name: "Wildlife",
                    logo: "assets/img/icons/logos/wildlife.svg",
                    distance: 0.5,
                    openingCount: "11pm",
                    phone: "+1 555 456-5659",
                    website: "https://ecojustice.thegreengrowth.com",
                    description: "Short Description of 10 Words about the Crime/Violation",
                },
                geometry: { type: "Point", coordinates: [-77.111561, 38.882342] },
            },
            {
                type: "Feature",
                properties: {
                    name: "Pollution",
                    logo: "assets/img/icons/logos/Pollution.svg",
                    distance: 0.2,
                    openingCount: "4:30pm",
                    phone: "+1 555 456-7568",
                    website: "https://ecojustice.thegreengrowth.com",
                    description: "Short Description of 10 Words about the Crime/Violation",
                },
                geometry: { type: "Point", coordinates: [-77.052477, 38.943951] },
            },
        ],
    };
function displayPopup(e) {
    var o = document.getElementsByClassName("mapboxgl-popup");
    o.length && o[0].remove(), map.flyTo({ center: e.coordinates, zoom: 15, bearing: 0, essential: !0 });
    var t =
        '<div class="map-box-location">\n    <div class="map-box-header">\n      <div class="media-flex-center">\n        <div class="h-avatar is-small">\n          <img\n            class="avatar"\n            src="' +
        e.logo +
        '"\n            alt=""\n          />\n        </div>\n        <div class="flex-meta">\n          <span>' +
        e.name +
        "</span>\n          <span>Open until " +
        e.openingCount +
        '</span>\n        </div>\n      </div>\n    </div>\n    <div class="map-box-body">\n      <p>' +
        e.description +
        "</p>\n    </div>\n  </div>";
    new mapboxgl.Popup().setLngLat(e.coordinates).setHTML(t).addTo(map);
}
function loadLayers() {
    if (!map.getSource("places")) {
        var e = window.localStorage.getItem("theme");
        map.addSource("places", { type: "geojson", data: locations }),
            map.addLayer({
                id: "places",
                type: "circle",
                source: "places",
                paint: { "circle-color": "dark" === e ? themeColors.accent : themeColors.primary, "circle-radius": 6, "circle-stroke-width": 2, "circle-stroke-color": "dark" === e ? "#ddd" : "#fff" },
            }),
            map.on("click", "places", function (e) {
                for (
                    var o = e.features[0].geometry.coordinates.slice(), t = e.features[0].properties.description, s = e.features[0].properties.logo, i = e.features[0].properties.name, a = e.features[0].properties.openingCount;
                    Math.abs(e.lngLat.lng - o[0]) > 180;

                )
                    o[0] += e.lngLat.lng > o[0] ? 360 : -360;
                displayPopup({ coordinates: o, name: i, description: t, logo: s, openingCount: a });
            }),
            map.on("mouseenter", "places", function () {
                map.getCanvas().style.cursor = "pointer";
            }),
            map.on("mouseleave", "places", function () {
                map.getCanvas().style.cursor = "";
            });
    }
}
function initMapBox() {
    var e = "mapbox://styles/mapbox/light-v10";
    if (("dark" === window.localStorage.getItem("theme") && (e = "mapbox://styles/mapbox/dark-v10"), $("#mapbox-1").length)) {
        (mapboxgl.accessToken = "pk.eyJ1IjoiY3NzbmluamEiLCJhIjoiY2toZW1nYm0zMDAxODJycXFzZ3g4cnZ6diJ9.9ebfrGREuwkauRr_afDTgA"),
            (map = new mapboxgl.Map({ container: "mapbox-1", style: e, center: [-77.04, 38.907], zoom: 12 })).on("styledata", function () {
                !(function e() {
                    map.isStyleLoaded() ? loadLayers() : setTimeout(e, 1500);
                })();
            });
        var o = new MapboxGeocoder({ accessToken: mapboxgl.accessToken, mapboxgl: mapboxgl, marker: !0 });
        document.getElementById("geocoder").appendChild(o.onAdd(map));
    }
}
$(function () {
    initMapBox(),
        $(".map-box").on("click", function () {
            $(".map-box").removeClass("is-active"), $(this).addClass("is-active");
            var e = parseInt($(this).attr("data-feature")),
                o = locations.features[e].geometry.coordinates,
                t = locations.features[e].properties.name,
                s = locations.features[e].properties.logo,
                i = locations.features[e].properties.openingCount;
            displayPopup({ coordinates: o, name: t, description: locations.features[e].properties.description, logo: s, openingCount: i });
        }),
        $(document).on("themeChange", function (e, o) {
            "dark" === o ? map.setStyle("mapbox://styles/mapbox/dark-v10") : map.setStyle("mapbox://styles/mapbox/light-v10");
        });
});
